package coreservlets;

import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Prosty serwlet ilustrujcy dziaanie
 *  parametrw inicjalizacyjnych serwletw.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */

public class InitServlet extends HttpServlet {
  private String firstName = "Brak imienia.";
  private String emailAddress = "Brak adresu poczty email.";

  public void init() {
    ServletConfig config = getServletConfig();
    if (config.getInitParameter("firstName") != null) {
      firstName = config.getInitParameter("firstName");
    }
    if (config.getInitParameter("emailAddress") != null) {
      emailAddress = config.getInitParameter("emailAddress");
    }
  }
  
  public void doGet(HttpServletRequest request,
                    HttpServletResponse response)
      throws ServletException, IOException {
    response.setContentType("text/html");
    response.setCharacterEncoding("UTF-8");
    PrintWriter out = response.getWriter();
    String uri = request.getRequestURI();
    out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 " +
                "Transitional//EN\">" + "\n" +
                "<HTML>\n" + "<HEAD><TITLE>" + 
                "InitServlet" + "</TITLE></HEAD>\n" +
                "<BODY BGCOLOR=\"#FDF5E6\">\n" +
                "<H2>Parametry inicjalizacyjne:</H2>\n" +
                "<UL>\n" +
                "<LI>Imi: " + firstName + "\n" +
                "<LI>Adres email: " + emailAddress + "\n" +
                "</UL>\n" + 
                "</BODY></HTML>");
  }
}
